var cams : Camera[];

var originalWidth : float;
var ratioX : int = 16;
var ratioY : int = 9;
var frameRate : int = 60;

function Start(){
	originalWidth = Screen.width;
	Application.targetFrameRate = frameRate;
	AdjustRatio();
}

function AdjustRatio(){
	Debug.Log(parseFloat(Screen.width) / parseFloat(Screen.height));
	
	width = parseFloat(Screen.width);
	height = parseFloat(Screen.height);
	
	xf = width / ratioX;
	desiredY = xf * ratioY;
	py = desiredY / height;
	yOffset = ((height - desiredY) / 2.0) / height;
	for(c in cams){
		c.rect = Rect(0,yOffset,1.0, py);
	}
}


function Update () {
	
	if(Screen.width != originalWidth){
		AdjustRatio();
		originalWidth = Screen.width;
	}
}