var explosion : GameObject;
var status : GameObject;
var points : int;
var startTime : float;
var maxTime : float;
var tracker : String;
var started : boolean;

function OnTriggerEnter(){
	if(!started) startTime = Time.time;
	started = true;
	//~ Debug.Log("Started");
}

function OnMouseUp(){
	Instantiate(explosion, transform.position, Quaternion.identity);
	
	//~ obj.SendMessage("SetText", parseInt(((Time.time - startTime) * 1000)).ToString() + "ms");
	
	if(!Score.frozen){
		obj = Instantiate(status, transform.position, Quaternion.identity);
		points = (1.0 - (Time.time - startTime) / maxTime) * points;
		obj.SendMessage("SetText", "+" + points);
		Score.AddPoints(points);
		Score.IncrementTracker(tracker);
		Score.IncrementHits();
		Score.AddReaction(Time.time - startTime);
	}
	//~ Focal.instance.SetFocalPoint(transform.position);
	gameObject.SendMessage("Disconnect", SendMessageOptions.DontRequireReceiver);
	Destroy(gameObject);
}

function Update(){
	if(started){
		if(Time.time - startTime > maxTime){
			Score.AddReaction(Time.time - startTime);
			Score.IncrementMisses();
			gameObject.SendMessage("Disconnect", SendMessageOptions.DontRequireReceiver);
			Destroy(gameObject);
		}
	}
}