enum _SessionState{INIT, STARTED, SCOREBOARD}
var state : _SessionState;
var skin : GUISkin;
var endStyle : GUIStyle;
var spawners : GameObject[];

var sessionEndTime : float;
var sessionLength : float;
var timeInt : int;

var instructions : GameObject;

function Start(){
	Achievement.CheckAchievements();
	Achievement.ShowAchievements(true);
	instructions.active = true;
}

function OnGUI(){
	GUI.skin = skin;
	if(state == _SessionState.INIT){
		GUILayout.BeginArea(Rect(0,Screen.height - 64,Screen.width, 64));
			if(GUILayout.Button("Start  (" + Kongregate.username + ")", GUILayout.Height(64))){
				for(s in spawners){
					s.active = true;
				}
				Score.InitScoring();
				Score.frozen = false;
				Score.showScore = false;
				Score.points = 0;
				sessionEndTime = Time.time + sessionLength;
				state = _SessionState.STARTED;
				Achievement.ShowAchievements(false);
				instructions.active = false;
			}
		GUILayout.EndArea();
	}
	
	if(state == _SessionState.STARTED){
		timeInt = sessionEndTime - Time.time;
		
		GUI.Label(Rect(Screen.width - 140, 0, 128, 128), timeInt.ToString());
		
		if(Time.time > sessionEndTime){
			state = _SessionState.SCOREBOARD;
			for(s in spawners){
				s.active = false;
			}
			Score.showScore = true;
			Score.frozen = true;
			//submit statistics
			Kongregate.SubmitStatistic("Highscore", Score.points);
			Kongregate.SubmitStatistic("RedTargets", Score.trackers["Red Targets"]);
			Kongregate.SubmitStatistic("GreyTargets", Score.trackers["Grey Targets"]);
			Kongregate.SubmitStatistic("LowestAvgResponse", Score.avgReaction);
			
			//check to see if reaction is worth an accomplishment
			Debug.Log("Avg reaction :: " + Score.avgReaction);
			if(Score.avgReaction < 1800 && Score.hits > 50){
				Debug.Log("Adding Superclicker :: " + Score.avgReaction);	
				Achievement.SetAchievement("SuperClicker", 1);
			}
			
			//check to see if reaction is worth an accomplishment
			if(Score.avgReaction < 1200 && Score.hits > 50){
				Debug.Log("Adding carpal :: " + Score.avgReaction);
				Achievement.SetAchievement("CarpalTunnelist", 1);
			}
			
			//check for red-handedness
			if(Score.trackers["Grey Targets"] == 0 && Score.trackers["Red Targets"] >= 5){
				Debug.Log("Adding RedHanded");
				Achievement.SetAchievement("RedHanded", 1);
			}
			
			
			//Check to show achievements in Unity and submit to kongregate
			Achievement.CheckAchievements();
			Achievement.ShowAchievements(true);
			
			//ACHIEVEMENTS/ACCOMPLISHMENTS NOTE:
			//Kongregate's API no longer supports a method to "Check" whether something has been achieved or check a score from the submitted score tables.
			//Any internal tracking you do is up to you; player prefs or whatever else.  This sucks :(  I know.
		}
	}
	
	if(state == _SessionState.SCOREBOARD){
		GUILayout.BeginArea(Rect(0,Screen.height - 64,Screen.width, 64));
			if(GUILayout.Button("Play Again", GUILayout.Height(64))){
				state = _SessionState.INIT;
				Score.showScore = false;
				instructions.active = true;
			}
		GUILayout.EndArea();
		
		
		//submit results if logged in
		if(Kongregate.isKongregate){
			GUI.Label(Rect(0,0,Screen.width,Screen.height), "Results Submitted!", endStyle);
		}
		//inform the user that they must login in order for score submission to actually work
		else{
			GUI.Label(Rect(0,0,Screen.width,Screen.height), "Not logged in.", endStyle);
		}
		
		//~ if(GUILayout.Button("Reset stats")){
			//~ PlayerPrefs.DeleteAll();
		//~ }
	}
}