static var points : int;
static var trackers : Hashtable;
static var reaction : float;
static var hits : int;
static var misses : int;
static var frozen : boolean;
static var showScore : boolean;
static var avgReaction : int;

static function IncrementTracker(str : String){
	if(!frozen) trackers[str] = trackers[str] + 1;
}

static function IncrementHits(){
	if(!frozen) hits++;
}

static function IncrementMisses(){
	if(!frozen) misses++;
}

static function AddPoints(i : int){
	if(!frozen) points += i;
}

static function AddReaction(f : float){
	if(!frozen) reaction += f;
}

static function InitScoring(){
	trackers = new Hashtable();
	//setup Statistic trackers for later reporting to Kongregate
	trackers.Add("Grey Targets", 0);
	trackers.Add("Red Targets", 0);
	reaction = 0;
	hits = 0;
	misses = 0;
	points = 0;
}

var skin : GUISkin;
function Start(){
	InitScoring();
	frozen = true;
}

function Update(){
	if(hits+misses > 0){
		Score.avgReaction = (reaction / (hits+misses))*1000;
	}
}
function OnGUI(){
	GUI.skin = skin;
	
	if(showScore){
		GUILayout.Label(Score.points.ToString() + " points");
		if(hits > 0 || misses > 0){
			
			GUILayout.Label("Avg Reaction: " + avgReaction + "ms");
		}
		for(var e : DictionaryEntry in trackers){
			GUILayout.Label(e.Key.ToString() + ":  " + e.Value.ToString());
		}
	}
	else{
		GUILayout.Label(" " + points);
		GUILayout.Label(" " + avgReaction + "ms");
	}
}