static var achievements : List.<Achievement>;
static var show : boolean;

static function InitAchievements(){
	if(achievements == null){
		achievements = new List.<Achievement>();
	}
	
}

static function CheckAchievements(){
	for(a in achievements){
		a.Check();
	}
}

static function ShowAchievements(state : boolean){
	for(var a : Achievement in achievements){
		if(state){
			a.Show();
		}
		else{
			a.Hide();
		}
	}
}

static function SetAchievement(str : String, val : int){
	PlayerPrefs.SetInt(Kongregate.username + "_" + str, val);
}

var pref : String;
var achieved : boolean;

function Awake(){
	InitAchievements();
	Achievement.achievements.Add(this);
}

function Check(){
	Debug.Log("Checking Achievment :: " + pref);
	if(PlayerPrefs.GetInt(Kongregate.username + "_" + pref, 0) > 0){
		achieved = true;
		Kongregate.SubmitStatistic(pref, 1);
	}
	else{
		achieved = false;
	}
}

function Show(){
	Debug.Log("Showing achievment :: " + achieved);
	if(achieved)gameObject.SetActiveRecursively(true);
	else{
		Hide();
	}
}

function Hide(){
	gameObject.SetActiveRecursively(false);
}